<?php
// Sécurité : ne doit pas être exécuté s'il n'est pas lancé par le script principal photos-script.php
if ( !defined('OK') )  exit();

// Ce script recherche et compte les images du répertoire racine, du cache, les images manquantes (à générer) dans le cache et les images obsolètes (à supprimer) dans le cache.
// Il renvoie du code en syntaxe JavaScript pour être utilisé par la page d'administration (en AJAX). Les tableaux sont initialisés dans la fonction AJAX appelante.

////////////////////////////////////////////////////////////////////////////////////
///////                               Initialisation                         ///////
////////////////////////////////////////////////////////////////////////////////////

// Gestion de la mémoire
// Quand la galerie est très importante (au moins à partir de 20000 fichiers), les
// 8M autorisés au script ne sont pas suffisants. 20M devraient suffire (sinon,
// augmenter encore cette valeur). La possibilité de faire la modification n'étant
// pas obligatoire, il faudra informer l'utilisateur s'il y a un problème (si
// la variable images_obsoletes n'existe pas dans le script JS).
@ini_set('memory_limit','20M');

////////////////////////////////////////////////////////////////////////////////////
///////                     Recherche des images du cache                    ///////
////////////////////////////////////////////////////////////////////////////////////

// Détermination de toutes les images actuelles du cache
// Le cache n'est pas censé contenir un sous-répertoire.
chdir($cache);
$listecache = glob("*");
// Envoi de l'information au script JS
echo "nbcache_actuel = " . count($listecache) . ";\n";

////////////////////////////////////////////////////////////////////////////////////
///////               Recherche des images manquantes du cache               ///////
////////////////////////////////////////////////////////////////////////////////////

// Fonction pour qui liste les images 
function liste_cache($rep_id,$rep)  {
  // $rep_id est l'identifiant du répertoire parent
  // $rep est le répertoire correspondant
  global $nbreps, $nbfichiers, $nbcache_final, $nbcache_manque, $film, $cache, $listecache_ok, $dimensions;
  // Récupération de la liste des miniatures du cache correspondant aux fichiers du répertoire.
  // On ne modifie pas la valeur globale de $listecache
  chdir($cache);
  $listecache = glob("$rep_id-*");
  // Récupération des liste de répertoires enfants et d'images/films
  chdir($rep);
  $listereps = glob("*", GLOB_ONLYDIR);
  natsort($listereps);
  $listereps = array_values($listereps);
  $listefichiers = glob("{*.jpg,*.JPG,*.jpeg,*.JPEG,*.png,*.PNG,*.mov,*.MOV,*.avi,*.AVI,*.mpg,*.MPG,*.mpeg,*.MPEG}", GLOB_BRACE);
  natsort($listefichiers);
  $listefichiers = array_values($listefichiers);
  // Comptage
  $nbreps += $nr = count($listereps);
  $nbfichiers += $nf = count($listefichiers);
  $nbcache_final += $nr + $nf;
  // Vérification pour les fichiers (photos/films)
  foreach ( $listefichiers as $i => $fichier )  {
    $id = "$rep_id-" . ($i+1);
    $sans_ext = substr($fichier,0,strrpos($fichier,"."));
    // Si c'est une photo (les quatrième et troisième lettres en partant de la fin sont '.j', 'jp' ou '.p'), tailles 1 et 2 à prendre en compte
    if ( stripos(" .jp.p",substr($fichier,-4,2)) )  {
      $nbcache_final++;
      foreach ( $dimensions as $taille => $dim )  {
        // Pour chaque taille, si la miniature n'est dans le cache, on devra la créer
        if ( FALSE === array_search("$id-$dim.$sans_ext.jpg", $listecache) )
          echo "images_manquantes[" . $nbcache_manque++ . "] = ['{$rep_id}',". ($i+1) . "," . ($taille+1) . "];\n";
        // Si elle est dans le cache, on l'enlève de la liste
        else  $listecache_ok[] = "$id-$dim.$sans_ext.jpg";
      }
    }
    // Si c'est un film, taille 1 seulement
    else  {
      $film = "'{$rep_id}'," . ($i+1);
      // Si la miniature de taille 1 n'est dans le cache, on devra la créer
      if ( FALSE === array_search("$id.$sans_ext.png", $listecache) )
        echo "images_manquantes[" . $nbcache_manque++ . "] = [$film,1];\n";
      // Si elle est dans le cache, on l'enlève de la liste
      else  $listecache_ok[] = "$id.$sans_ext.png";
    }
  }
  // Vérification pour le répertoire
  if ( $rep_id )  {
    // $listecache ne contient pas l'éventuelle icône du répertoire. On teste directement si elle existe
    if ( !file_exists("$cache$rep_id." . substr(strrchr(substr($rep,0,-1),'/'),1) . ".png") )
      echo "images_manquantes[" . $nbcache_manque++ . "] = ['{$rep_id}'];\n";
    // Si elle est dans le cache, on l'enlève de la liste
    else  $listecache_ok[] = "$rep_id." . substr(strrchr(substr($rep,0,-1),'/'),1) . ".png";
  }
  else  $rep_id = "";
  // Lancements récursifs
  foreach ( $listereps as $i => $nouvrep )  {
    $id = $rep_id . sprintf("%02d",$i+1);
    liste_cache($id,"$rep$nouvrep/");
  }
}

// Initialisation
$nbreps = 0;
$nbfichiers = 0;
$nbcache_final = 0;
$nbcache_manque = 0;
$film = "";
$listecache_ok = array();

// Détermination de toutes les images attendues dans le cache
liste_cache(0,$rep_racine);
// On veut "0.parent.png" et "repertoire.png" ssi on a des sous-répertoires.
if ( $nbreps )  {
  $nbcache_final += 2;
  foreach ( array("0.parent.png","repertoire.png") as $image )  {
    // Si l'icône "Répertoire parent" (puis l'icône générique des répertoires)
    // n'est dans le cache, on devra la créer
    if ( FALSE === array_search($image, $listecache) )
      echo "images_manquantes[" . $nbcache_manque++ . "] = [0];\n";
    // Si elle est dans le cache, on l'enlève de la liste
    else  $listecache_ok[] = $image;
  }
}
// On veut "video-{dimensions[0]}.png" et "video-{dimensions[1]}.png" ssi on a des films.
if ( $film )  {
  $nbcache_final += 2;
  foreach ( $dimensions as $taille => $dim )  {
    // Si l'icône générique taille 1 n'est dans le cache, on devra la créer
    if ( FALSE === array_search("video-$dim.png", $listecache) )
      echo "images_manquantes[" . $nbcache_manque++ . "] = [$film," . ($taille+1) . "];\n";
    // Si elle est dans le cache, on l'enlève de la liste
    else  $listecache_ok[] = "video-$dim.png";
  }
}

// Envoi des données au script JS
echo "nbreps = $nbreps;\n";
echo "nbfichiers = $nbfichiers;\n";
echo "nbcache_final = $nbcache_final;\n";
echo "nbcache_manque = $nbcache_manque;\n";
flush();

// Suppression des images "non obsolètes" de $listecache et envoi des données
echo "images_obsoletes = ['" . @implode(array_map("rawurlencode",array_diff($listecache,$listecache_ok)),"','") . "'];\n";
?>