<?php
// Sécurité : ne doit pas être exécuté s'il n'est pas lancé par le script principal photos-script.php
if ( !defined('OK') )  exit();

//////////////////////////////////////////////////////////////////////////////////
///////            Initialisation - récupération des variables             ///////
//////////////////////////////////////////////////////////////////////////////////

// Récupération du répertoire
// Les répertoires sont numérotés, par ordre alphabétique dans le répertoire parent.
// Chaque niveau est représenté sur deux chiffres (on ne pourra pas avoir plus de 100 répertoires enfant par répertoire), en partant de l'unité et en multipliant par 100 à chaque niveau. Exemple : "502" correspond au cinquième répertoire dans le deuxième répertoire dans le répertoire racine. 
chdir($rep_racine);
$i = 0;
$rep = "";
$rep_id = "";
if ( isset($_REQUEST['rep']) )  {
  if ( is_numeric($_REQUEST['rep']) )
    $i = (fmod(strlen($_REQUEST['rep']),2)) ?  "0" . $_REQUEST['rep'] : $_REQUEST['rep'];
  else  {
    header("Location: $adresse");
    exit;
  }
}

// Vérification de l'existence du répertoire. Si c'est faux, $rep_id devient false et on est renvoyé à la racine.
while ($i > 0)  {
  $listereps = glob("*", GLOB_ONLYDIR);
  natsort($listereps);
  $listereps = array_values($listereps);
  if ( $nouvrep = $listereps[substr($i,0,2)-1] ) {
    $rep .= "$nouvrep/";
    $rep_id = $rep_id . substr($i,0,2);
    chdir($nouvrep);
    $i = substr($i,2);
  }
  else  {
    header("Location: $adresse");
    exit;
  }
}
// Si $rep_id est 'intacte', il faut le mettre à zéro pour pouvoir afficher l'icône "répertoire parent" ou les images du répertoire racine. On ne peut pas le faire avant, si on demande machin.php?rep=0 on n'aura pas trouvé de répertoire dans le while précédent et on aura $rep_id valant "".
if ( !$rep_id )  {
  $rep_id = 0;
  $nouvrep = "parent"; // Uniquement pour le nom de l'image 
}

// Récupération de l'image
// Les images et films sont numérotés par ordre alphabétique.
$img = "";
$img_id = 0;
if ( is_null($_REQUEST['img']) )  return;
if ( is_numeric($_REQUEST['img']) )  $img_id = floor($_REQUEST['img']);
else  {
// Si $_REQUEST["img"] n'est pas correcte, redirection en enlevant ce paramètre
  header("Location: $adresse?rep=$rep_id");
  exit;
}

if ( $img_id > 0 )  {
  $listeimgs = glob("{*.jpg,*.JPG,*.jpeg,*.JPEG,*.png,*.PNG,*.mov,*.MOV,*.avi,*.AVI,*.mpg,*.MPG,*.mpeg,*.MPEG}", GLOB_BRACE);
  natsort($listeimgs);
  $listeimgs = array_values($listeimgs);
  if ( !($img = $listeimgs[$img_id-1]) )  {
  header("Location: $adresse?rep=$rep_id");
    exit; 
  }
}
elseif ( $img_id == -1 )  {
// Si $img_id vaut -1, on veut générer une image vide pour afficher sur les côtés quand l'image centrale est la première ou la dernière du répertoire
  header("Content-type: image/png");
  $image = imagecreate($dimensions[1],$dimensions[1]);
  $blanc = imagecolorallocate($image,255,255,255);
  imagepng($image);
  imagedestroy($image);   
  exit;
}
else  {
  header("Location: $adresse?rep=$rep_id");
  exit; 
}

?>